varying vec2 v_texCoord;

uniform sampler2D s_texture0; // src tex
uniform vec2 center0; // Mouse position
uniform float time0; // effect elapsed time
uniform vec4 color0;
uniform vec2 center1; // Mouse position
uniform float time1; // effect elapsed time
uniform vec4 color1;
uniform vec3 shockParams; // 10.0, 0.8, 0.1
uniform float numBooms;

void main()
{
  vec2 uv = v_texCoord.xy;
  vec2 texCoord = uv;
  vec4 color = vec4(0,0,0,0);
  vec4 tcolor = vec4(0,0,0,0);
  float distance = distance(uv, center0);
  if ((distance <= (time0 + shockParams.z)) &&
  (distance >= (time0 - shockParams.z)) )
  {
    float diff = (distance - time0);
    float powDiff = 1.0 - pow(abs(diff*shockParams.x),shockParams.y);
    float diffTime = diff  * powDiff;
    vec2 diffUV = normalize(uv - center0);
    texCoord = uv + (diffUV * diffTime);
//    tcolor = texture2D(s_texture0, texCoord);
    if(diff > 0.0) {
      color = color0*diff*4.0;
    }
  }
  distance = distance(uv, center1);
  if ((distance <= (time1 + shockParams.z)) &&
  (distance >= (time1 - shockParams.z)) )
  {
    float diff = (distance - time1);
    float powDiff = 1.0 - pow(abs(diff*shockParams.x),shockParams.y);
    float diffTime = diff  * powDiff;
    vec2 diffUV = normalize(uv - center1);
    texCoord = uv + (diffUV * diffTime);
    if(diff > 0.0) {
      color += color1*diff*4.0;
    }
  }
  gl_FragColor = vec4(texture2D(s_texture0, texCoord).rgb,1) + color;
}
